/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.biomes;

import java.awt.Color;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.biomes.BiomeDecoratorTFC;
import net.dries007.tfc.world.classic.spawner.WorldEntitySpawnerTFC;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeTFC
extends Biome {
    public final Color debugColor;
    private final int waterPlantsPerChunk;
    private final int lilyPadPerChunk;
    private boolean spawnBiome;

    public BiomeTFC(int debugColor, Biome.BiomeProperties properties) {
        this(debugColor, properties, 0, 0);
    }

    public BiomeTFC(int debugColor, Biome.BiomeProperties properties, int lilyPadPerChunk, int waterPlantsPerChunk) {
        super(properties);
        this.debugColor = new Color(debugColor);
        this.lilyPadPerChunk = lilyPadPerChunk;
        this.waterPlantsPerChunk = waterPlantsPerChunk;
        this.field_76760_I = this.func_76729_a();
        this.field_76762_K.clear();
        this.spawnBiome = false;
        for (String input : ConfigTFC.General.WORLD.respawnableCreatures) {
            Class entityClass;
            int max;
            int min;
            int rarity;
            String[] split = input.split(" ");
            if (split.length != 4) continue;
            ResourceLocation key = new ResourceLocation(split[0]);
            try {
                rarity = Integer.parseInt(split[1]);
                min = Integer.parseInt(split[2]);
                max = Integer.parseInt(split[3]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
            if (entityEntry == null || !EntityLiving.class.isAssignableFrom(entityClass = entityEntry.getEntityClass())) continue;
            this.field_76762_K.add(new Biome.SpawnListEntry(entityClass, rarity, min, max));
        }
        for (Class clazz : WorldEntitySpawnerTFC.LIVESTOCK.keySet()) {
            this.field_76762_K.add(new Biome.SpawnListEntry(clazz, 300, 1, 1));
        }
    }

    public String toString() {
        return this.field_76791_y;
    }

    @Nonnull
    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorTFC(this.lilyPadPerChunk, this.waterPlantsPerChunk);
    }

    public float func_180626_a(@Nonnull BlockPos pos) {
        return MathHelper.func_76131_a((float)(0.15f + ClimateTFC.getDailyTemp(pos) / 35.0f), (float)-1.0f, (float)1.0f);
    }

    public boolean func_185352_i() {
        return this.spawnBiome;
    }

    public Biome setSpawnBiome() {
        this.spawnBiome = true;
        return this;
    }
}

